# Stable

[![Go Report Card](https://goreportcard.com/badge/github.com/stablelabs/stable)](https://goreportcard.com/report/github.com/stablelabs/stable)
[![Go Version](https://img.shields.io/badge/Go-1.23+-00ADD8?logo=go)](https://golang.org/)

Stable is the first Stablechain—a high-performance Layer 1 blockchain dedicated to USDT-native operations. Built on a delegated Proof-of-Stake (dPoS) mechanism with full EVM compatibility, Stable achieves sub-second block times (~0.75s) for fast and reliable transaction finality.

## Features

- **Sub-Second Block Finality**: ~0.75 second block time with single-slot finality
- **100% EVM Compatibility**: Full support for Ethereum tooling and smart contracts
- **USDT as Gas Token**: Pay gas fees in USDT, with automatic token conversions
- **Gas-Free USDT0 Transfers**: Transfer USDT0 without gas fees via EIP-7702 and Account Abstraction
- **StableBFT Consensus**: Custom dPoS protocol for high throughput and low latency
- **Custom Modules**: precompile, inflation, budget, govshuttle, restriction

## Documentation

- [Stable Documentation](https://docs.stable.xyz/)
- [Go-Ethereum Documentation](https://geth.ethereum.org/docs)

---

## Quick Start

### Prerequisites

| Requirement | Version | Installation |
|-------------|---------|--------------|
| **Go** | 1.23+ | [golang.org/doc/install](https://golang.org/doc/install) |
| **Make** | GNU Make | `apt install make` or `brew install make` |
| **Git** | 2.x+ | `apt install git` or `brew install git` |

### Installation

```bash
# Clone the repository
git clone https://github.com/stablelabs/stable.git
cd stable

# Build and install the binary
make install

# Verify installation
stabled version
```

### Run Local Node

```bash
# Initialize a local node
stabled init mynode --chain-id stable-local-1

# Start the node
stabled start

# In another terminal, verify the node is running
stabled status
```

### Verify Installation

```bash
# Check node status (should return JSON with sync info)
stabled status 2>&1 | jq .sync_info

# Query latest block
stabled query block --type=height 1
```

---

## System Requirements

### Full Node

| Resource | Specification                                 |
|----------|-----------------------------------------------|
| **CPU** | 8 cores |
| **RAM** | 32 GB                                         |
| **Storage** | 500 GiB NVMe                                  |
| **Network** | 1 Gbps                                        |
| **OS** | Ubuntu 24.04 LTS                              |

### Archive Node

| Resource | Specification |
|----------|-------------|
| **CPU** | 16 cores |
| **RAM** | 64 GB |
| **Storage** | 4 TB NVMe (plan for expansion) |
| **Network** | 1 Gbps |
| **OS** | Ubuntu 24.04 LTS |

---

## Networks

### Mainnet

| Parameter | Value |
|-----------|-------|
| **Chain ID** | `stable_988-1` |
| **EVM Chain ID** | `988` |
| **Gas Token** | gUSDT |
| **Gov Token** | STABLE |
| **Block Time** | ~0.75 seconds |
| **RPC Endpoint** | https://rpc.stable.xyz |
| **Block Explorer** | https://stablescan.xyz |

```bash
# Initialize for mainnet
stabled init <moniker> --chain-id stable_988-1

# Download genesis file
wget https://raw.githubusercontent.com/stablelabs/stable/main/Networks/mainnet/genesis.json \
  -O $HOME/.stabled/config/genesis.json

# Configure minimum gas prices
sed -i 's/minimum-gas-prices = ""/minimum-gas-prices = "0.0001agusdt"/g' \
  $HOME/.stabled/config/app.toml
```

### Testnet

| Parameter | Value |
|-----------|-------|
| **Chain ID** | `stabletestnet_2201-1` |
| **EVM Chain ID** | `2201` |
| **Gas Token** | gUSDT |
| **Gov Token** | STABLE |
| **Block Time** | ~0.75 seconds |
| **RPC Endpoint** | https://rpc.testnet.stable.xyz |
| **Block Explorer** | https://testnet.stablescan.xyz |
| **Faucet** | https://faucet.stable.xyz |

```bash
# Download the latest testnet binary (Linux AMD64)
wget https://stable-testnet-data.s3.us-east-1.amazonaws.com/stabled-latest-linux-amd64-testnet.tar.gz
tar -xvzf stabled-latest-linux-amd64-testnet.tar.gz
sudo mv stabled /usr/bin/

# Initialize for testnet
stabled init <moniker> --chain-id stabletestnet_2201-1

# Download testnet genesis
wget https://stable-testnet-data.s3.us-east-1.amazonaws.com/stable_testnet_genesis.zip
unzip stable_testnet_genesis.zip
cp genesis.json $HOME/.stabled/config/genesis.json
```

---

## Validator Setup

### 1. Generate Keys

```bash
# Create a new key
stabled keys add <key_name>

# Or recover from mnemonic
stabled keys add <key_name> --recover

# Or use Ledger hardware wallet
stabled keys add <key_name> --ledger
```

> **Important**: Store your mnemonic securely offline. Never share it with anyone.

### 2. Configure Node

```bash
# Add persistent peers (testnet)
PEERS="5ed0f977a26ccf290e184e364fb04e268ef16430@37.187.147.27:26656,128accd3e8ee379bfdf54560c21345451c7048c7@37.187.147.22:26656"
sed -i "s/persistent_peers = \"\"/persistent_peers = \"$PEERS\"/g" \
  $HOME/.stabled/config/config.toml
```

### 3. Setup Systemd Service

Create the service file:

```bash
sudo tee /etc/systemd/system/stabled.service > /dev/null <<EOF
[Unit]
Description=Stable Node
After=network.target

[Service]
Type=simple
User=$USER
WorkingDirectory=$HOME
ExecStart=$(which stabled) start \\
  --log_level info \\
  --json-rpc.api eth,txpool,net,debug,web3 \\
  --api.enable
Restart=on-failure
RestartSec=3
LimitNOFILE=65535

[Install]
WantedBy=multi-user.target
EOF
```

Enable and start the service:

```bash
sudo systemctl daemon-reload
sudo systemctl enable stabled
sudo systemctl start stabled

# View logs
journalctl -u stabled -f
```

### 4. Create Validator

Once your node is synced, create the validator:

```bash
stabled tx staking create-validator \
  --amount=1000000astable \
  --pubkey=$(stabled comet show-validator) \
  --moniker="<VALIDATOR_NAME>" \
  --chain-id=stable_988-1 \
  --commission-rate="0.05" \
  --commission-max-rate="0.20" \
  --commission-max-change-rate="0.01" \
  --min-self-delegation="1" \
  --from=<KEY_NAME> \
  --fees=20agusdt
```

### Security Best Practices

- Run validator on a dedicated server with SSH key authentication only
- Use a firewall to restrict access (allow only P2P port 26656)
- Set up monitoring and alerting for node health
- Keep your system and stabled binary up to date
- Consider using a sentry node architecture for DDoS protection

---

## Architecture

Stable is built on a high-performance stack optimized for USDT operations:

```text
┌─────────────────────────────────────────────────────┐
│                   Stable EVM                         │
│         (100% EVM Compatible + Precompiles)         │
├─────────────────────────────────────────────────────┤
│  x/precompile  │  x/inflation  │  x/restriction     │
│  x/budget      │  x/govshuttle │  EIP-7702 / AA     │
├─────────────────────────────────────────────────────┤
│                    StableBFT                         │
├─────────────────────────────────────────────────────┤
│                    StableDB                          │
│            (MemDB + VersionDB + mmap)               │
└─────────────────────────────────────────────────────┘
```

### Core Components

| Component | Description |
|-----------|-------------|
| **StableBFT** | Custom dPoS consensus protocol for high throughput and low latency |
| **Stable EVM** | Ethereum-compatible execution layer with precompiles for native chain operations |
| **StableDB** | Optimized state storage separating commitment from storage for faster block processing |

### Key Modules

| Module | Description |
|--------|-------------|
| `x/precompile` | EVM execution with custom precompiles (ERC20, Staking, Distribution) |
| `x/inflation` | Token inflation and distribution management |
| `x/budget` | Farming and budget distribution for DeFi |
| `x/govshuttle` | Governance-controlled feature toggles |
| `x/restriction` | Address blocklisting and restrictions |

---

## Contributing

We welcome contributions! Please see [CONTRIBUTING.md](CONTRIBUTING.md) for guidelines.

### Quick Contribution Guide

1. Fork the repository
2. Create a feature branch (`git checkout -b feat/amazing-feature`)
3. Commit your changes (`git commit -m 'feat: add amazing feature'`)
4. Push to your branch (`git push origin feat/amazing-feature`)
5. Open a Pull Request

---

## Community

- **Website**: [stable.xyz](https://stable.xyz)
- **Discord**: [discord.gg/stablexyz](https://discord.gg/stablexyz)
- **X (Twitter)**: [x.com/stable](https://x.com/stable)
- **GitHub Issues**: [stablelabs/stable/issues](https://github.com/stablelabs/stable/issues)

