# Stable

[![Go Report Card](https://goreportcard.com/badge/github.com/stablelabs/stable)](https://goreportcard.com/report/github.com/stablelabs/stable)
[![Go Version](https://img.shields.io/badge/Go-1.23+-00ADD8?logo=go)](https://golang.org/)

Stable is the first Stablechain — a dedicated payments Layer 1 where stablecoins like USDT are used natively for gas and settlement. Built on a delegated Proof-of-Stake (dPoS) mechanism with full EVM compatibility, Stable achieves sub-second block times (~0.7s) for fast and reliable transaction finality.

## Features

- **Sub-Second Block Finality**: Sub-second block time with single-slot finality
- **100% EVM Compatibility**: Full support for Ethereum tooling and smart contracts
- **USDT as Gas Token**: Users pay gas fees in USDT0, automatically converted to gUSDT by the bundler and paymaster system
- **Simplified User Experience**: Users only need to hold USDT0 tokens, with the protocol handling all gas token conversions automatically
- **USDT0 Cross-Chain Bridge**: Bridge USDT0 from other chains including Ethereum, Arbitrum, HyperEVM, and Tron
- **Web2.5 UX through Stable Pay**: Seamless user experience provided by Stable Pay

## Documentation

For comprehensive guides and API references, visit the [Stable Documentation](https://docs.stable.xyz/).

---

## Networks

### Mainnet

| Parameter | Value |
|-----------|-------|
| **Chain ID** | `stable_988-1` |
| **EVM Chain ID** | `988` |
| **Gas Token** | gUSDT |
| **Gov Token** | STABLE |
| **Block Time** | ~0.7 seconds |
| **RPC Endpoint** | https://rpc.stable.xyz |
| **Block Explorer** | [stablescan.xyz](https://stablescan.xyz) |

### Testnet

| Parameter | Value |
|-----------|-------|
| **Chain ID** | `stabletestnet_2201-1` |
| **EVM Chain ID** | `2201` |
| **Gas Token** | gUSDT |
| **Gov Token** | STABLE |
| **Block Time** | ~0.7 seconds |
| **RPC Endpoint** | https://rpc.testnet.stable.xyz |
| **Block Explorer** | [testnet.stablescan.xyz](https://testnet.stablescan.xyz) |
| **Faucet** | [faucet.stable.xyz](https://faucet.stable.xyz) |

---

## Run a Node

For detailed node operation guides, see the [Node Operations Documentation](https://docs.stable.xyz/en/developers/node-operations/overview).

### System Requirements

#### Full Node (Recommended)

| Resource | Specification |
|----------|---------------|
| **CPU** | 8 cores (AMD Ryzen 7 / Intel Core i7 or better) |
| **RAM** | 16 GB (32 GB for optimal performance) |
| **Storage** | 1 TB NVMe (Write throughput > 2000 MiBps) |
| **Network** | 1 Gbps |
| **OS** | Ubuntu 24.04 LTS |

#### Archive Node

| Resource | Specification |
|----------|---------------|
| **CPU** | 16 cores (AMD Ryzen 9 / Intel Core i9 or equivalent) |
| **RAM** | 32 GB (64 GB recommended) |
| **Storage** | 4 TB NVMe (plan for expansion) |
| **Network** | 1 Gbps |
| **OS** | Ubuntu 24.04 LTS |

### Docker Quick Start

Official Docker images are available at `ghcr.io/stablelabs/stable`.

| Tag | Description |
|-----|-------------|
| `latest` | Latest mainnet release |
| `latest-testnet` | Latest testnet release |
| `X.Y.Z-mainnet` | Specific mainnet version |
| `X.Y.Z-testnet` | Specific testnet version |

```bash
# Pull and verify image
docker pull ghcr.io/stablelabs/stable:latest
docker run --rm ghcr.io/stablelabs/stable:latest version
```

### Run with Docker Compose

Create a `docker-compose.yml` file:

```yaml
services:
  stabled:
    image: ghcr.io/stablelabs/stable:latest
    container_name: stabled
    restart: unless-stopped
    ports:
      - "26656:26656"  # P2P
      - "26657:26657"  # RPC
      - "1317:1317"    # REST API
      - "8545:8545"    # EVM JSON-RPC HTTP
      - "8546:8546"    # EVM JSON-RPC WebSocket
      - "9090:9090"    # gRPC
    volumes:
      - stabled-data:/home/stable/.stabled
    command: >
      start
      --json-rpc.api eth,txpool,net,debug,web3
      --api.enable
    logging:
      driver: json-file
      options:
        max-size: "100m"
        max-file: "5"

volumes:
  stabled-data:
```

```bash
docker compose up -d
docker compose logs -f
```

### Exposed Ports

| Port | Protocol | Description |
|------|----------|------------|
| 26656 | TCP | P2P networking |
| 26657 | TCP | RPC |
| 1317 | TCP | REST API |
| 8545 | TCP | EVM JSON-RPC (HTTP) |
| 8546 | TCP | EVM JSON-RPC (WebSocket) |
| 9090 | TCP | gRPC |

---

## Architecture

Stable is designed with a focus on performance, scalability, and reliability. Each component of the stack is optimized to support high-throughput workloads and seamless USDT-native operations.

```text
┌─────────────────────────────────────────────────────┐
│                   Stable EVM                        │
│         (100% EVM Compatible + Precompiles)         │
├─────────────────────────────────────────────────────┤
│  x/precompile  │  x/inflation  │  x/restriction     │
│  x/budget      │ EIP-7702 / AA │                    │
├─────────────────────────────────────────────────────┤
│                    StableBFT                        │
├─────────────────────────────────────────────────────┤
│                    StableDB                         │
└─────────────────────────────────────────────────────┘
```

### Core Components

| Component | Description |
|-----------|-------------|
| **StableBFT** | Custom PoS consensus protocol built on CometBFT for high throughput and low latency. Future upgrade to DAG-based Autobahn for parallel proposal processing and faster finality. |
| **Stable EVM** | Ethereum-compatible execution layer with precompiles enabling EVM smart contracts to call into core chain logic securely and atomically. |
| **StableDB** | Separates state commitment from storage, allowing blocks to process without delay. Uses MemDB for in-memory handling of recent data. |
| **High Performance RPC** | Split-path architecture separating operations by function with lightweight, specialized RPC nodes for faster response times. |

### Key Modules

| Module | Description |
|--------|-------------|
| `x/precompile` | EVM execution with custom precompiles (ERC20, Staking, Distribution) |
| `x/inflation` | Token inflation and distribution management |
| `x/budget` | Farming and budget distribution for DeFi |
| `x/restriction` | Address blocklisting and restriction |

---

## Community

- **Website**: [stable.xyz](https://stable.xyz)
- **Documentation**: [docs.stable.xyz](https://docs.stable.xyz)
- **Discord**: [discord.gg/stablexyz](https://discord.gg/stablexyz)
- **X (Twitter)**: [x.com/stable](https://x.com/stable)
- **GitHub Issues**: [stablelabs/stable/issues](https://github.com/stablelabs/stable/issues)
