<!--
Guiding Principles:

Changelogs are for humans, not machines.
There should be an entry for every single version.
The same types of changes should be grouped.
Versions and sections should be linkable.
The latest version comes first.
The release date of each version is displayed.
Mention whether you follow Semantic Versioning.

Usage:

Change log entries are to be added to the Unreleased section under the
appropriate stanza (see below). Each entry is required to include a tag and
the Github issue reference in the following format:

* (<tag>) \#<issue-number> message

The tag should consist of where the change is being made ex. (x/staking), (store)
The issue numbers will later be link-ified during the release process so you do
not have to worry about including a link manually, but you can if you wish.

Types of changes (Stanzas):

"Features" for new features.
"Improvements" for changes in existing functionality.
"Deprecated" for soon-to-be removed features.
"Bug Fixes" for any bug fixes.
"Client Breaking" for breaking Protobuf, gRPC and REST routes used by end-users.
"CLI Breaking" for breaking CLI commands.
"API Breaking" for breaking exported APIs used by developers building on SDK.
"State Machine Breaking" for any changes that result in a different AppState given same genesisState and txList.
Ref: https://keepachangelog.com/en/1.0.0/
-->

# Changelog

## [Unreleased]
N/A

## [v1.1.4](https://github.com/stablelabs/stable/releases/tag/v1.1.4)

### Improvements

* (*) Replace LGPL-3.0 with custom Delayed Open-Source License from Stable Foundation. This source-available license automatically converts to Apache 2.0 on December 8, 2055.
* (*) Update stable-bft to v0.38.20-stable.
* (*) Update stable-evm to v0.3.2-stable-4.

### Bug Fixes

* (*) [#128](https://github.com/stablelabs/stable/pull/128) Update stable-evm to v0.3.2-stable-2 to restore evm-chain-id configuration in app.toml. This fixes json-rpc server using default chain id instead of configured chain id.


## [v1.1.2](https://github.com/stablelabs/stable/releases/tag/v1.1.2)

### Improvements

* (x/restriction) [#117](https://github.com/stablelabs/stable/pull/117) Remove unused OracleHooks interface and related code that was never registered or utilized in production.

### Bug Fixes

* (*) [#107](https://github.com/stablelabs/stable/pull/107) Bump-up gogoproto bug fix.
* (x/inflation) [#110](https://github.com/stablelabs/stable/pull/110) Replace math.Pow with deterministic LegacyDec implementation to ensure consistent results across ARM64 and AMD64 architectures.
* (cmd/stabled) [#112](https://github.com/stablelabs/stable/pull/112) Use build-time EVMChainID instead of local config in newApp and appExport to prevent non-deterministic behavior from misconfiguration.
* (x/restriction) [#120](https://github.com/stablelabs/stable/pull/120) Fix Potential Chain Halt by ERC20 Blocked Address Check on Block Handlers.

### State Machine Breaking

* (x/govshuttle) [#115](https://github.com/stablelabs/stable/pull/115) Remove unused govshuttle module. Module store will be deleted during v1.1.2 upgrade.
* (x/feegrant) [#116](https://github.com/stablelabs/stable/pull/116) Remove feegrant module as it is not used in Stable chain after genesis. Module store will be deleted during v1.1.2 upgrade
* (app/upgrades) [#123](https://github.com/stablelabs/stable/pull/123) Clear budget module parameters and transfer remaining funds (Approximately 3~4 gUSDT) from budget destination address to target address. After upgrade, staking rewards will flow directly from fee collector to distribution module without budget plan intermediation.

### Bug Fixes
* (x/restriction) [#120](https://github.com/stablelabs/stable/pull/120) Fix Potential Chain Halt by ERC20 Blocked Address Check on Block Handlers.

## [v1.1.1](https://github.com/stablelabs/stable/releases/tag/v1.1.1) * for only testnet

### Features

* (app/upgrades) [#108](https://github.com/stablelabs/stable/pull/108) Add v1.1.1 testnet upgrade handler to initialize epoch module and enable inflation on testnet.

## [v1.1.0](https://github.com/stablelabs/stable/releases/tag/v1.1.0)

### Features

* (*) [#104](https://github.com/stablelabs/stable/pull/104) Add upgrade handler for v1.1.0.

## [v1.0.0](https://github.com/stablelabs/stable/releases/tag/v1.0.0)

### Features

* (x/restriction) [#25](https://github.com/stablelabs/stable/pull/25) Add evm value transfer allow list.
* (x/restriction) [#30](https://github.com/stablelabs/stable/pull/30) Change evm value transfer allow list steps(admin -> manager -> allowed addresses).
* (precompiles/budget, precompiles/inflation) [#36](https://github.com/stablelabs/stable/pull/36) Add budget and inflation precompile.
* (x/precompile) [#42](https://github.com/stablelabs/stable/pull/42) Add USDT0 token supply invariant check to prevent over-issuance of gas coins.
* (precompiles/restriction) [#43](https://github.com/stablelabs/stable/pull/43) Add restriction precompile for EOA whitelist management with addEOA, removeEOA, isWhitelisted, and getWhitelisted methods.
* (x/restriction) [#48](https://github.com/stablelabs/stable/pull/48) Add USDT restriction logic which prevents gas coin transfers from blocked addresses in USDT0 contract using isBlocked view function.
* (app/precompiles) [#58](https://github.com/stablelabs/stable/pull/58) Add gov, slashing precompile from existing feature in the cosmos/evm & upgrade testnet-v6 for updating the params of EVM.
* (app/restriction) [#70](https://github.com/stablelabs/stable/pull/70) Remove eoa whitelist for evm value transfer, so that eoa can transfer evm value with no restriction. And also add upgrade handler for testnet-v7.
* (*) [#71](https://github.com/stablelabs/stable/pull/70) Rename gas denom from `ausdt` to `agasusdt`.
* (*) [#90](https://github.com/stablelabs/stable/pull/90) Bump up stable-bft to v0.38.19-stable-0, stable-sdk to v0.53.4-stable-1 and stable-evm to v0.3.0-stable-7.
* (*) [#96](https://github.com/stablelabs/stable/pull/96) Bump up stable-evm to v0.3.2-stable-0.
* (x/precompile) [#100](https://github.com/stablelabs/stable/pull/100) Usdt0TokenAddress gRPC query endpoint to retrieve registered USDT0 token address in precompile module
* (cmd/stabled) [#105](https://github.com/stablelabs/stable/pull/105) Update a vaule of specific namespace `stablebft` instead of `cometbft`

### Improvements

* (posthandler) [#2](https://github.com/stablelabs/stable/pull/2) Use log.Address for processing restriction event.
* (x/restriction) [#7](https://github.com/stablelabs/stable/pull/7) Move restriction flags to params.
* (precompiles/bank) [#11](https://github.com/stablelabs/stable/pull/11) Use msg server from bank precompile.
* (precompiles/*) [#13](https://github.com/stablelabs/stable/pull/13) Move duplicated precompile check logic to common.
* (x/precompile) [#14](https://github.com/stablelabs/stable/pull/14) Remove duplicated denom validation check.
* (app/ante) [#15](https://github.com/stablelabs/stable/pull/15) Apply minor comments.
  * Add nil check for handler options.
  * Remove fundAccount and replace with SetAccount.
  * Remove evm denom from MinGasPriceDecorator that is sdk side ante handler.
* (contracts) [#16](https://github.com/stablelabs/stable/pull/16) Contract gas efficiency.
* (x/inflation) [#17](https://github.com/stablelabs/stable/pull/17) Add fuzz test for allocate inflation.
* (x/restriction) [#25](https://github.com/stablelabs/stable/pull/25) Add evm value transfer allow list.
* (precompiles/bank) [#33](https://github.com/stablelabs/stable/pull/33) Add bank precompile instance for governance coin.
* (app/ante) [#34](https://github.com/stablelabs/stable/pull/34) Remove ante handler to allow only evm tx and disable sdk tx.
* (x/budget) [#36](https://github.com/stablelabs/stable/pull/36) Suppport evm address from MsgUpdateParams proposal of x/budget.
* (x/precompile) [#37](https://github.com/stablelabs/stable/pull/37) Remove staking, distribution permissions.
* (x/inflation) [#38](https://github.com/stablelabs/stable/pull/38) Refactor x/inflation.
  * Fixed returning to the LegacyDec type without considering precision.
* (app/upgrades) [#50](https://github.com/stablelabs/stable/pull/50) Modify testnet-v4 upgrade handler for migrating allowedListAddresses to EOAWhitelist.
* (precompiles/bank) [#72](https://github.com/stablelabs/stable/pull/72) Match events of bank precompile with ERC20.
* (app/upgrades) [#82](https://github.com/stablelabs/stable/pull/82) Add testnet-v8 upgrade handler to mint astable.
* (precompiles/*) [#83](https://github.com/stablelabs/stable/pull/83) Add ReturnRevertError for precompiles.
* (precompiles/bank) [#88](https://github.com/stablelabs/stable/pull/88) Add name, symbol and decimals methods to bank precompile.
* (app/upgrades) [#92](https://github.com/stablelabs/stable/pull/92) Add testnet-v8.1 upgrade handler for onboarding validators on testnet.
* (*) [#84](https://github.com/stablelabs/stable/pull/84) Inject chain-id from build-time.
* (ci) [#98](https://github.com/stablelabs/stable/pull/98) Build both mainnet and testnet binaries simultaneously in goreleaser regardless of tag suffix.
* (cmd/stabled) [#99](https://github.com/stablelabs/stable/pull/99) Generate a default chain-id in the telemetric as global values, Update a specific chain-id not random suffix in the genesis file.
* (evm) [#101](https://github.com/stablelabs/stable/pull/101) Return nil from evm tx when commit.

### Bug Fixes

* (x/inflation) [#1](https://github.com/stablelabs/stable/pull/1) Remove period from epoch provision formula.
* (x/inflation) [#3](https://github.com/stablelabs/stable/pull/3) Use pre-defined variable for event emit.
* (precompiles/bank) [#5](https://github.com/stablelabs/stable/pull/5) Add max recipients length on multi-transfer of bank precompile.
* (precompiles/staking) [#8](https://github.com/stablelabs/stable/pull/8) Fix commission field of MsgCreateValidator.
* (precompiles/staking) [#9](https://github.com/stablelabs/stable/pull/9) Set balanceChangeEntries in createValidator of staking precompile.
* (precompiles/bank) [#10](https://github.com/stablelabs/stable/pull/10) Add convert decimals to some methods of bank precompile.
* (precompiles/staking) [#12](https://github.com/stablelabs/stable/pull/12) Error msg for delegation query.
* (precompiles/*) [#18](https://github.com/stablelabs/stable/pull/18) Remove tx.origin from precompiles.
* (x/restriction) [#31](https://github.com/stablelabs/stable/pull/31) Fix off-by-one error in allowed addresses limit check.
* (app/ante) [#44](https://github.com/stablelabs/stable/pull/44) Allow sdk tx from ante handler for genesis txs.
* (app/upgrade) [#52](https://github.com/stablelabs/stable/pull/52) Add USDT0 token address to precompile module keeper from upgrade handler.
* (app) [#54](https://github.com/stablelabs/stable/pull/54) Use evm.evm-chain-id from app.toml.
* (x/restriction) [#64](https://github.com/stablelabs/stable/pull/64) Fix USDT0 restriction to validate both sender and recipient addresses during transfers.
* (*) [#91](https://github.com/stablelabs/stable/pull/91) Modify module path from github.com/stablelabs/stable/v1 to github.com/stablelabs/stable
* (precompiles/bank) [#93](https://github.com/stablelabs/stable/pull/93) Fix non-deterministic output ordering in multiTransfer by sorting outputs by address.

### CLI Breaking

* (cli) [#34](https://github.com/stablelabs/stable/pull/34) Remove tx and query commands from sdk cli.
* (x/restriction) [#43](https://github.com/stablelabs/stable/pull/43) Remove EOA whitelist management keeper methods and CLI commands. Use precompile interface instead.

### State Machine Breaking

* (x/restriction) [#7](https://github.com/stablelabs/stable/pull/7) Move restriction flags to params.
* (x/restriction) [#25](https://github.com/stablelabs/stable/pull/25) Add evm value transfer allow list.
* (x/restriction) [#30](https://github.com/stablelabs/stable/pull/30) Change evm value transfer allow list steps(admin -> manager -> allowed addresses).
* (x/inflation) [#38](https://github.com/stablelabs/stable/pull/38) Refactor x/inflation.
  * Change epochProvision from sdk.DecProto to sdk.Coin.
* (x/precompile) [#42](https://github.com/stablelabs/stable/pull/42) Added a new `usdt0TokenAddress` state within the module, marking a state-breaking change `x/restriction`
* (x/restriction) [#43](https://github.com/stablelabs/stable/pull/43) Update genesis state structure for testnet-v4 compatibility. Remove deprecated manager_addresses and allowed_lists fields.
* (x/restriction) [#70](https://github.com/stablelabs/stable/pull/70) Remove `EOAWhitelist` from restriction keeper.
* (precompiles) [#97](https://github.com/stablelabs/stable/pull/97) Use static error messages for precompile txs to ensure determinism. 
