# Stable

- Cosmos-SDK v0.50.x, CometBFT v0.38.x, ABCI 2.0
- Ethermint with Precompiles (ERC20, WIP: Issuance, Staking, Distribution)
- epochs and inflation module
- budget and govshuttle module for farming use cases
- restriction module for blocklisting

## Install `stabled`

### Clone git repository

```bash
git clone https://github.com/stablelabs/stable.blob/mainn/cmd/stabled
go install -tags ledger ./...
sudo mv $HOME/go/bin/stabled /usr/bin/

```

### Generate and store keys

Replace `<keyname>` below with whatever you'd like to name your key.

- `stabled keys add <key_name>`
- `stabled keys add <key_name> --recover` to regenerate keys with your mnemonic
- `stabled keys add <key_name> --ledger` to generate keys with ledger device

Store a backup of your keys and mnemonic securely offline.

Then save the generated public key config in the main Stable directory as `<key_name>.info`. It should look like this:

```json
pubkey: {
  "@type":" ethermint.crypto.v1.ethsecp256k1.PubKey",
  "key":"############################################"
}
```

You'll use this file later when creating your validator txn.

## Set up validator

Install stabled binary from `stable` directory:

`sudo make install`

Initialize the node. Replace `<moniker>` with whatever you'd like to name your validator.

`stabled init <moniker> --chain-id stable_988-1`

If this runs successfully, it should dump a blob of JSON to the terminal.

Download the Genesis file:

`wget https://raw.githubusercontent.com/stablelabs/stable/blob/main/Networks/sample_genesis/genesis.json -P $HOME/.stabled/config/`

> _**Note:** If you later get `Error: couldn't read GenesisDoc file: open /root/.stabled/config/genesis.json: no such file or directory` put the genesis.json file wherever it wants instead, such as:
>
> `sudo wget https://raw.githubusercontent.com/stablelabs/stable/blob/main/Networks/sample_genesis/genesis.json -P/root/.stabled/config/`

Edit the minimum-gas-prices in `${HOME}/.stabled/config/app.toml`:

`sed -i 's/minimum-gas-prices = "0astable"/minimum-gas-prices = "0.0001astable"/g' $HOME/.stabled/config/app.toml`

Add persistent peers to `$HOME/.stabled/config/config.toml`:
`sed -i 's/persistent_peers = ""/persistent_peers = "ec770ae4fd0fb4871b9a7c09f61764a0b010b293@164.90.134.106:26656"/g' $HOME/.stabled/config/config.toml`

### Set `stabled` to run automatically

- Start `stabled` by creating a systemd service to run the node in the background:
- Edit the file: `sudo nano /etc/systemd/system/node.service`
- Then copy and paste the following text into your service file. Be sure to edit as you see fit.

```bash

[Unit]
Description="Stable Node"
After=network.target

[Service]
Type=simple
User=root
WorkingDirectory=/root/
ExecStart=/root/go/bin/stabled start --trace --log_level info --json-rpc.api eth,txpool,net,debug,web3 --api.enable
Restart=on-failure
StartLimitInterval=0
RestartSec=3
LimitNOFILE=65535
LimitMEMLOCK=209715200

[Install]
WantedBy=multi-user.target

```

## Start the node

Reload the service files:

`sudo systemctl daemon-reload`

Create the symlinlk:

`sudo systemctl enable node.service`

Start the node:

`sudo systemctl start stabled && journalctl -u stabled -f`

You should then get several lines of log files and then see: `No addresses to dial. Falling back to seeds module=pex server=node`

This is an indicator things thus far are working and now you need to create your validator txn. `^c` out and follow the next steps.

### Create Validator Transaction

Modify the following items below, removing the `<>`

- `<KEY_NAME>` should be the same as `<key_name>` when you followed the steps above in creating or restoring your key.
- `<VALIDATOR_NAME>` is whatever you'd like to name your node
- `<DESCRIPTION>` is whatever you'd like in the description field for your node
- `<SECURITY_CONTACT_EMAIL>` is the email you want to use in the event of a security incident
- `<YOUR_WEBSITE>` the website you want associated with your node
- `<TOKEN_DELEGATION>` is the amount of tokens staked by your node (`1astable` should work here, but you'll also need to make sure your address contains tokens.)

```bash

stabled tx staking create-validator \
--from <KEY_NAME> \
--chain-id stable_988-1 \
--moniker="<VALIDATOR_NAME>" \
--commission-max-change-rate=0.01 \
--commission-max-rate=1.0 \
--commission-rate=0.05 \
--details="<DESCRIPTION>" \
--security-contact="<SECURITY_CONTACT_EMAIL>" \
--website="<YOUR_WEBSITE>" \
--pubkey $(stabled tendermint show-validator) \
--min-self-delegation="1" \
--amount <TOKEN_DELEGATION>astable \
--fees 20astable

```
